<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'user') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/database.php";

$id_user = $_SESSION['id_user'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard User - Sistem Bantuan Sosial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);
            min-height: 100vh;
            font-family: 'Arial', sans-serif;
            animation: bgFade 2s ease-in-out;
            margin: 0;
            padding: 0;
        }
        @keyframes bgFade {
            0% { opacity: 0; }
            100% { opacity: 1; }
        }
        .dashboard-container {
            padding: 40px 20px;
            animation: containerSlide 1s ease-out;
        }
        @keyframes containerSlide {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .welcome-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: none;
            margin-bottom: 30px;
            animation: cardFade 0.8s ease-out 0.2s forwards;
            opacity: 0;
            padding: 20px;
        }
        @keyframes cardFade {
            to { opacity: 1; transform: translateY(0); }
            from { opacity: 0; transform: translateY(20px); }
        }
        .action-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            border: none;
            padding: 30px;
            text-align: center;
            transition: all 0.3s ease;
            animation: actionStagger 0.6s ease-out forwards;
            opacity: 0;
            height: 100%;
        }
        .action-card:nth-child(1) { animation-delay: 0.4s; }
        .action-card:nth-child(2) { animation-delay: 0.6s; }
        .action-card:nth-child(3) { animation-delay: 0.8s; }
        @keyframes actionStagger {
            to { opacity: 1; transform: translateY(0) scale(1); }
            from { opacity: 0; transform: translateY(30px) scale(0.9); }
        }
        .action-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
        }
        .action-card i {
            font-size: 3rem;
            color: #0984e3;
            margin-bottom: 15px;
            animation: iconPulse 2s ease-in-out infinite;
        }
        @keyframes iconPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
        .action-card h5 {
            color: #333;
            font-weight: 600;
            margin-bottom: 15px;
        }
        .action-card p {
            color: #666;
            margin-bottom: 20px;
            font-size: 0.9rem;
        }
        .btn-custom {
            border-radius: 10px;
            padding: 12px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin: 5px 0;
            animation: btnFade 0.5s ease-out 1s forwards;
            opacity: 0;
            text-decoration: none;
            display: inline-block;
        }
        @keyframes btnFade {
            to { opacity: 1; }
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        .btn-primary { background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%); border: none; color: white; }
        .btn-info { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); border: none; color: white; }
        .btn-danger { background: linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%); border: none; color: white; }
        .container {
            max-width: 1200px;
        }
    </style>
</head>
<body>
<div class="dashboard-container">
    <div class="container">
        <div class="welcome-card">
            <h3 class="text-center mb-0"><i class="fas fa-home"></i> Dashboard User</h3>
            <p class="text-center mt-2">Selamat datang, <strong><?= htmlspecialchars($_SESSION['nama']) ?></strong>! Kelola pengajuan bantuan sosial Anda dengan mudah.</p>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-4 mb-4">
                <div class="action-card">
                    <i class="fas fa-plus-circle"></i>
                    <h5>Ajukan Bantuan</h5>
                    <p>Ajukan bantuan sosial untuk program yang tersedia.</p>
                    <a href="ajukan_bantuan.php" class="btn btn-primary btn-custom"><i class="fas fa-plus"></i> Ajukan Sekarang</a>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="action-card">
                    <i class="fas fa-list-alt"></i>
                    <h5>Pengajuan Saya</h5>
                    <p>Lihat status pengajuan bantuan Anda.</p>
                    <a href="pengajuan_saya.php" class="btn btn-info btn-custom"><i class="fas fa-eye"></i> Lihat Pengajuan</a>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="action-card">
                    <i class="fas fa-sign-out-alt"></i>
                    <h5>Logout</h5>
                    <p>Keluar dari sistem bantuan sosial.</p>
                    <a href="../auth/logout.php" class="btn btn-danger btn-custom"><i class="fas fa-sign-out-alt"></i> Logout</a>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
