<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'user') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/database.php";

$program = mysqli_query($conn,"SELECT * FROM program_bantuan ORDER BY nama_program ASC");

if (isset($_POST['ajukan'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama']);
    $alamat = mysqli_real_escape_string($conn, $_POST['alamat']);
    $no_hp = mysqli_real_escape_string($conn, $_POST['no_hp']);
    $keterangan = mysqli_real_escape_string($conn, $_POST['keterangan']);
    $dana = mysqli_real_escape_string($conn, $_POST['dana']);
    $id_program = intval($_POST['id_program']);
    $id_user = intval($_SESSION['id_user']);
    
    $stmt = mysqli_prepare($conn, "INSERT INTO pengajuan (id_user, id_program, tanggal_pengajuan, status, nama, alamat, no_hp, keterangan, dana) VALUES (?, ?, CURDATE(), 'pending', ?, ?, ?, ?, ?)");
    if (!$stmt) {
        die("Prepare failed: " . mysqli_error($conn));
    }
    mysqli_stmt_bind_param($stmt, "iisssss", $id_user, $id_program, $nama, $alamat, $no_hp, $keterangan, $dana);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    header("Location: pengajuan_saya.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Ajukan Bantuan - Sistem Bantuan Sosial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);
            min-height: 100vh;
            font-family: 'Arial', sans-serif;
            animation: bgFade 2s ease-in-out;
            margin: 0;
            padding: 0;
        }
        @keyframes bgFade {
            0% { opacity: 0; }
            100% { opacity: 1; }
        }
        .form-container {
            padding: 40px 20px;
            animation: containerSlide 1s ease-out;
        }
        @keyframes containerSlide {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: none;
            animation: cardFade 0.8s ease-out 0.2s forwards;
            opacity: 0;
            padding: 30px;
        }
        @keyframes cardFade {
            to { opacity: 1; transform: translateY(0); }
            from { opacity: 0; transform: translateY(20px); }
        }
        .form-group {
            animation: formStagger 0.5s ease-out forwards;
            opacity: 0;
        }
        .form-group:nth-child(1) { animation-delay: 0.2s; }
        .form-group:nth-child(2) { animation-delay: 0.4s; }
        .form-group:nth-child(3) { animation-delay: 0.6s; }
        .form-group:nth-child(4) { animation-delay: 0.8s; }
        .form-group:nth-child(5) { animation-delay: 1s; }
        .form-group:nth-child(6) { animation-delay: 1.2s; }
        @keyframes formStagger {
            to { opacity: 1; transform: translateX(0); }
            from { opacity: 0; transform: translateX(-20px); }
        }
        .form-control {
            border-radius: 10px;
            border: 1px solid #ddd;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        .form-control:focus {
            border-color: #0984e3;
            box-shadow: 0 0 8px rgba(9, 132, 227, 0.3);
            transform: scale(1.02);
        }
        .form-select {
            border-radius: 10px;
            border: 1px solid #ddd;
            padding: 12px 15px;
            transition: all 0.3s ease;
        }
        .form-select:focus {
            border-color: #0984e3;
            box-shadow: 0 0 8px rgba(9, 132, 227, 0.3);
        }
        .btn-custom {
            border-radius: 10px;
            padding: 12px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin: 5px;
            animation: btnFade 0.5s ease-out 1.4s forwards;
            opacity: 0;
        }
        @keyframes btnFade {
            to { opacity: 1; }
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        .btn-primary { background: linear-gradient(135deg, #0984e3 0%, #74b9ff 100%); border: none; }
        .btn-secondary { background: linear-gradient(135deg, #636e72 0%, #b2bec3 100%); border: none; }
        .container {
            max-width: 600px;
        }
    </style>
</head>
<body>
<div class="form-container">
    <div class="container">
        <div class="form-card">
            <h3 class="text-center mb-4"><i class="fas fa-plus-circle"></i> Ajukan Bantuan</h3>
            <p class="text-center mb-4">Silakan isi data diri Anda terlebih dahulu sebelum mengajukan bantuan.</p>
            <form method="post">
                <div class="form-group mb-3">
                    <label for="nama" class="form-label"><i class="fas fa-user"></i> Nama Lengkap</label>
                    <input type="text" name="nama" id="nama" class="form-control" autocomplete="off" required>
                </div>
                <div class="form-group mb-3">
                    <label for="alamat" class="form-label"><i class="fas fa-map-marker-alt"></i> Alamat Lengkap</label>
                    <textarea name="alamat" id="alamat" class="form-control" placeholder="Contoh: Jl. Sudirman No. 123, Jakarta" required></textarea>
                </div>
                <div class="form-group mb-3">
                    <label for="no_hp" class="form-label"><i class="fas fa-phone"></i> Nomor HP</label>
                    <input type="text" name="no_hp" id="no_hp" class="form-control" placeholder="Contoh: 081234567890" required>
                </div>
                <div class="form-group mb-3">
                    <label for="id_program" class="form-label"><i class="fas fa-hand-holding-heart"></i> Pilih Program Bantuan</label>
                    <select name="id_program" id="id_program" class="form-select" required>
                        <option value="">-- Pilih Program --</option>
                        <?php while($p = mysqli_fetch_assoc($program)): ?>
                            <option value="<?= intval($p['id_program']) ?>"><?= htmlspecialchars($p['nama_program']) ?></option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group mb-3">
                    <label for="keterangan" class="form-label"><i class="fas fa-comment"></i> Keterangan Tambahan (Opsional)</label>
                    <textarea name="keterangan" id="keterangan" class="form-control" placeholder="Contoh: Membutuhkan bantuan untuk biaya pendidikan anak"></textarea>
                </div>
                <div class="form-group mb-3">
                    <label for="dana" class="form-label"><i class="fas fa-money-bill-wave"></i> Dana yang Diajukan (Rp)</label>
                    <input type="number" name="dana" id="dana" class="form-control" placeholder="Masukkan jumlah dana yang diajukan" min="0" step="0.01" required>
                </div>
                <div class="text-center">
                    <button type="submit" name="ajukan" class="btn btn-primary btn-custom"><i class="fas fa-paper-plane"></i> Ajukan Bantuan</button>
                    <a href="dashboard.php" class="btn btn-secondary btn-custom"><i class="fas fa-arrow-left"></i> Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
