<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Jika sudah login, redirect ke dashboard masing-masing
if (isset($_SESSION['role'])) {
    if ($_SESSION['role'] == 'admin') {
        header("Location: admin/dashboard.php");
        exit;
    } elseif ($_SESSION['role'] == 'user') {
        header("Location: user/dashboard.php");
        exit;
    } else {
        header("Location: auth/login.php");
        exit;
    }
}

// Jika belum login, tampilkan halaman home
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Bantuan Sosial - Home</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <style>
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 100px 0;
            text-align: center;
        }
        .hero-section h1 {
            font-size: 3rem;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .hero-section p {
            font-size: 1.2rem;
            margin-bottom: 30px;
        }
        .features-section {
            padding: 80px 0;
            background: #f8f9fa;
        }
        .feature-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            padding: 30px;
            text-align: center;
            transition: transform 0.3s ease;
        }
        .feature-card:hover {
            transform: translateY(-10px);
        }
        .feature-card i {
            font-size: 3rem;
            color: #667eea;
            margin-bottom: 20px;
        }
        .cta-section {
            background: linear-gradient(135deg, #00b894 0%, #00cec9 100%);
            color: white;
            padding: 60px 0;
            text-align: center;
        }
        .footer {
            background: #343a40;
            color: white;
            padding: 40px 0;
            text-align: center;
        }
        .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="#"><i class="fas fa-hand-holding-heart"></i> Bantuan Sosial</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="#features">Fitur</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="auth/login.php">Login</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="auth/register.php">Daftar</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <h1>Selamat Datang di Sistem Bantuan Sosial</h1>
            <p>Membantu masyarakat dalam mendapatkan bantuan sosial dengan mudah dan transparan.</p>
            <a href="auth/register.php" class="btn btn-light btn-lg me-3"><i class="fas fa-user-plus"></i> Daftar Sekarang</a>
            <a href="auth/login.php" class="btn btn-outline-light btn-lg"><i class="fas fa-sign-in-alt"></i> Masuk</a>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features-section">
        <div class="container">
            <h2 class="text-center mb-5">Fitur Utama</h2>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="feature-card">
                        <i class="fas fa-file-alt"></i>
                        <h4>Pengajuan Bantuan</h4>
                        <p>Ajukan bantuan sosial dengan mudah melalui platform kami.</p>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="feature-card">
                        <i class="fas fa-check-circle"></i>
                        <h4>Verifikasi Cepat</h4>
                        <p>Proses verifikasi yang cepat dan transparan oleh admin.</p>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="feature-card">
                        <i class="fas fa-chart-bar"></i>
                        <h4>Laporan Lengkap</h4>
                        <p>Monitoring dan laporan pengajuan bantuan secara real-time.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <h2>Bergabunglah Sekarang</h2>
            <p>Daftar akun Anda dan mulai ajukan bantuan sosial hari ini.</p>
            <a href="auth/register.php" class="btn btn-light btn-lg"><i class="fas fa-rocket"></i> Mulai Sekarang</a>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <p>&copy; 2026 Sistem Bantuan Sosial. Semua hak dilindungi.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
