<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}
include "../config/database.php";

// Statistik
$query = mysqli_query($conn, "SELECT COUNT(*) as total FROM program_bantuan");
$program = mysqli_fetch_assoc($query)['total'];

$query = mysqli_query($conn, "SELECT COUNT(*) as total FROM users WHERE role='user'");
$user = mysqli_fetch_assoc($query)['total'];

$query = mysqli_query($conn, "SELECT COUNT(*) as total FROM pengajuan");
$pengajuan = mysqli_fetch_assoc($query)['total'];

$query = mysqli_query($conn, "SELECT COUNT(*) as total FROM pengajuan WHERE status='disetujui'");
$disetujui = mysqli_fetch_assoc($query)['total'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin - Sistem Bantuan Sosial</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Arial', sans-serif;
            animation: bgFade 2s ease-in-out;
        }
        @keyframes bgFade {
            0% { opacity: 0; }
            100% { opacity: 1; }
        }
        .dashboard-container {
            padding: 40px 20px;
            animation: containerSlide 1s ease-out;
        }
        @keyframes containerSlide {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .welcome-card {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            backdrop-filter: blur(10px);
            border: none;
            margin-bottom: 30px;
            animation: cardFade 0.8s ease-out 0.2s forwards;
            opacity: 0;
        }
        @keyframes cardFade {
            to { opacity: 1; transform: translateY(0); }
            from { opacity: 0; transform: translateY(20px); }
        }
        .card-stat {
            background: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(10px);
            border: none;
            transition: all 0.3s ease;
            animation: statStagger 0.6s ease-out forwards;
            opacity: 0;
        }
        .card-stat:nth-child(1) { animation-delay: 0.4s; }
        .card-stat:nth-child(2) { animation-delay: 0.6s; }
        .card-stat:nth-child(3) { animation-delay: 0.8s; }
        .card-stat:nth-child(4) { animation-delay: 1s; }
        @keyframes statStagger {
            to { opacity: 1; transform: translateY(0) scale(1); }
            from { opacity: 0; transform: translateY(30px) scale(0.9); }
        }
        .card-stat:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.2);
        }
        .card-stat .card-body {
            text-align: center;
            padding: 30px;
        }
        .card-stat h5 {
            color: #666;
            font-weight: 600;
            margin-bottom: 10px;
        }
        .card-stat h2 {
            color: #333;
            font-weight: bold;
            font-size: 2.5rem;
            margin: 0;
        }
        .card-stat i {
            font-size: 3rem;
            color: #667eea;
            margin-bottom: 15px;
            animation: iconPulse 2s ease-in-out infinite;
        }
        @keyframes iconPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
        .btn-custom {
            border-radius: 10px;
            padding: 12px 20px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin: 5px;
            animation: btnFade 0.5s ease-out 1.2s forwards;
            opacity: 0;
        }
        @keyframes btnFade {
            to { opacity: 1; }
        }
        .btn-custom:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }
        .btn-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border: none; }
        .btn-warning { background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%); border: none; }
        .btn-info { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); border: none; }
        .btn-danger { background: linear-gradient(135deg, #ff9a9e 0%, #fecfef 100%); border: none; }
    </style>
</head>
<body>
<div class="dashboard-container">
    <div class="container">
        <div class="welcome-card card p-4">
            <h3 class="text-center mb-0"><i class="fas fa-tachometer-alt"></i> Dashboard Admin</h3>
            <p class="text-center mt-2">Selamat datang, <strong><?= htmlspecialchars($_SESSION['nama']) ?></strong>! Kelola sistem bantuan sosial dengan mudah.</p>
        </div>
        <div class="row">
            <div class="col-md-3 mb-4">
                <div class="card card-stat">
                    <div class="card-body">
                        <i class="fas fa-list-ul"></i>
                        <h5>Program Bantuan</h5>
                        <h2><?= $program ?></h2>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card card-stat">
                    <div class="card-body">
                        <i class="fas fa-users"></i>
                        <h5>Total User</h5>
                        <h2><?= $user ?></h2>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card card-stat">
                    <div class="card-body">
                        <i class="fas fa-file-alt"></i>
                        <h5>Total Pengajuan</h5>
                        <h2><?= $pengajuan ?></h2>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="card card-stat">
                    <div class="card-body">
                        <i class="fas fa-check-circle"></i>
                        <h5>Disetujui</h5>
                        <h2><?= $disetujui ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <hr style="border: 1px solid rgba(255,255,255,0.3); animation: hrFade 0.5s ease-out 1.4s forwards; opacity: 0;">
        <div style="text-align: center;">
            <a href="program_bantuan.php" class="btn btn-primary btn-custom"><i class="fas fa-plus"></i> Kelola Program</a>
            <a href="verifikasi_pengajuan.php" class="btn btn-warning btn-custom"><i class="fas fa-check"></i> Verifikasi Pengajuan</a>
            <a href="laporan_pengajuan.php" class="btn btn-info btn-custom"><i class="fas fa-chart-bar"></i> Laporan</a>
            <a href="../auth/logout.php" class="btn btn-danger btn-custom"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
